import random
import time
import turtle
turtle.tracer(1000, 0) # Zwiększ wartość pierwszego argumentu, aby przyspieszyć rysowanie
turtle.setworldcoordinates(0, 0, 700, 700)
turtle.hideturtle()

def drawBranch(startPosition, direction, branchLength):
    if branchLength < 5:
        # PRZYPADEK BAZOWY
        return

    # Przesunięcie żółwia do punktu startowego i nadanie mu początkowego kierunku
    turtle.penup()
    turtle.goto(startPosition)
    turtle.setheading(direction)

    # Rysowanie gałęzi (grubość gałęzi to 1/7 jej długości)
    turtle.pendown()
    turtle.pensize(max(branchLength / 7.0, 1))
    turtle.forward(branchLength)

    # Zapisywanie pozycji końca gałęzi
    endPosition = turtle.position()
    leftDirection = direction + LEFT_ANGLE
    leftBranchLength = branchLength - LEFT_DECREASE
    rightDirection = direction - RIGHT_ANGLE
    rightBranchLength = branchLength - RIGHT_DECREASE

    # PRZYPADEK REKURENCYJNY
    drawBranch(endPosition, leftDirection, leftBranchLength)
    drawBranch(endPosition, rightDirection, rightBranchLength)

seed = 0
while True:
    # Losowanie parametrów gałęzi
    random.seed(seed)
    LEFT_ANGLE     = random.randint(10,  30)
    LEFT_DECREASE  = random.randint( 8,  15)
    RIGHT_ANGLE    = random.randint(10,  30)
    RIGHT_DECREASE = random.randint( 8,  15)
    START_LENGTH   = random.randint(80, 120)

    # Wypisanie ziarna
    turtle.clear()
    turtle.penup()
    turtle.goto(10, 10)
    turtle.write('Ziarno: %s' % (seed))

    # Rysowanie drzewa
    drawBranch((350, 10), 90, START_LENGTH)
    turtle.update()
    time.sleep(2)

    seed = seed + 1

